/*
 * Copyright (C) 2000 - 2024 Silverpeas
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * As a special exception to the terms and conditions of version 3.0 of
 * the GPL, you may redistribute this Program in connection with Free/Libre
 * Open Source Software ("FLOSS") applications as described in Silverpeas's
 * FLOSS exception.  You should have received a copy of the text describing
 * the FLOSS exception, and it is also available here:
 * "https://www.silverpeas.org/legal/floss_exception.html"
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package org.silverpeas.core.web.util.viewgenerator.html.buttonpanes;

import org.silverpeas.core.web.util.viewgenerator.html.SimpleGraphicElement;
import org.silverpeas.core.web.util.viewgenerator.html.buttons.Button;

/**
 * The Browse interface gives us the skeleton for all funtionnalities we need to display typical WA
 * browse bar
 * @author neysseri
 * @version 1.0
 */
public interface ButtonPane extends SimpleGraphicElement {

  /**
   * Sets some CSS classes
   * @param cssClass CSS classes.
   */
  void setCssClass(String cssClass);

  /**
   * Method declaration
   * @param button
   * @see
   */
  void addButton(Button button);

  /**
   * Method declaration
   * @see
   */
  void setVerticalPosition();

  /**
   * Method declaration
   * @param width
   * @see
   */
  void setVerticalWidth(String width);

  /**
   * Method declaration
   * @see
   */
  void setHorizontalPosition();

  /**
   * Print the browseBar in an html format.
   * @return The html based line code
   */
  String print();

}
